<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticleCategoriesWidget
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class BlogHomeWidget extends CWidget
{
    
    
    public function run()
    {
	 
			if(!Yii::app()->extensionsManager->isExtensionEnabled('blog')):
			return null;
			endif;
 
			$articleCategoryFromSlug = ArticleCategory::model()->findByAttributes(array('slug'=>'industry-news'));
			 
			 
			$criteria=new CDbCriteria;
			$criteria->with = array('categories') ;
			$criteria->condition = 't.status=:pub and  categories.category_id=:parent';
		 
			$criteria->params[':pub']   = 'published'  ;
			$criteria->params[':parent']   = $articleCategoryFromSlug->category_id  ;
			$criteria->together =true;
			$criteria->limit = 3;
			$model=Article::model()->findAll($criteria);
			$this->render('menu',compact('model','articleCategoryFromSlug'));
	 
    }
}
